## Why Python for Network Automation?

- Python is a simple yet powerful language with efficient data structures and object-oriented capabilities.
- Its elegant syntax, dynamic typing, and interpreted nature make it ideal for scripting and rapid development.
- Widely supported by Cisco networking products for both on-box and off-box automation.

---

## Python Availability and Support

- Python interpreter and standard library are freely available for all major platforms ([python.org](http://www.python.org/)).
- Many Cisco devices (switches/routers) provide an on-box Python interpreter.
- Devices include Python libraries for:
    - Direct CLI command execution
    - Event monitoring
    - Batch command execution

---

## On-Box and Off-Box Automation with Python

### On-Box Automation

- Execute Python scripts directly on Cisco devices.
- Automate device CLI operations and local event responses.

### Off-Box Automation

- Use Python scripts to interact with external APIs (e.g., NETCONF, RESTCONF, REST).
- Example: Retrieve network inventory data from Cisco Catalyst Center via REST API.

---

## Cisco Secure Firewall Management Center (FMC) and Python

### Python with FMC REST API

- Automate tasks such as:
    - Retrieving audit records
    - Creating objects and policies
    - Registering or deregistering devices
- Scripts can be custom-built or sourced from community repositories (e.g., GitHub).
- Swagger CodeGen can generate sample code based on the Open API Spec for FMC.

---

## Using Swagger CodeGen with Open API Spec

### Purpose

- Generates sample code for all supported REST API endpoints.
- Supports multiple languages: Python, Java, Perl, HTML, etc.
- Useful as an educational and starting point for custom automation.

### Steps to Generate Code

1. Download the Open API Spec file from FMC API Explorer.
2. Download the CodeGen tool ([link](https://repo1.maven.org/maven2/io/swagger/swagger-codegen-cli/)).
3. Run the CodeGen tool using the command:
    - `java -jar ./swagger-codegen-cli-<VERSION>.jar generate -o <OUTPUT_PATH> -l <LANGUAGE> -i <OPEN_API_SPEC_FILE>`
    - Replace `<VERSION>`, `<OUTPUT_PATH>`, `<LANGUAGE>`, `<OPEN_API_SPEC_FILE>` accordingly.
4. Use the generated code as a template or starting point.

---

## Example: Python Script with FMC REST API

### Key Components of the Script

- Imports required libraries (json, sys, requests).
- Collects FMC address, username, and password.
- Generates authentication token via REST API call.
- Sets token in request headers.
- Performs a GET request to retrieve system information.
- Processes and prints the JSON response if successful.

### Example Use Case

- The script demonstrates retrieving the server version from FMC.
- Similar scripts can be adapted for other REST API endpoints and tasks.

---

## Key Takeaways

- Python is a primary tool for network automation on Cisco platforms.
- Scripts can be run directly on devices or remotely using APIs.
- Open API Spec and tools like Swagger CodeGen accelerate script development and integration.
- Extensive community resources (e.g., GitHub) are available to jumpstart automation efforts.